#!/bin/bash

BASEDIR=$(dirname "$0")
COMMAND="$BASEDIR/BroadcastScanner"

if command -v gnome-terminal &> /dev/null
then
    echo "Found gnome-terminal"
    gnome-terminal -- bash -c "$COMMAND; exec bash"
elif command -v xterm &> /dev/null
then
    echo "Found xterm"
    xterm -hold -e "$COMMAND"
elif command -v konsole &> /dev/null
then
    echo "Found konsole"
    konsole -e "$COMMAND; exec bash"
elif command -v mate-terminal &> /dev/null
then
    echo "Found mate-terminal"
    mate-terminal -- bash -c "$COMMAND; exec bash"
elif command -v fly-term &> /dev/null
then
    echo "Found fly-term"
    fly-term -hold -e "$COMMAND"
elif command -v xfce4-terminal &> /dev/null
then
    echo "Found xfce4-terminal"
    xfce4-terminal -hold -e "$COMMAND"
else
    echo "No compatible terminal emulator found"
    exit 1
fi
